/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.component;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import com.mojang.serialization.MapCodec;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.VecDirection;
import com.technicalitiesmc.lib.util.PropertyMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class ComponentState
extends StateHolder<ComponentType, ComponentState> {
    private static final Supplier<ForgeRegistry<ComponentType>> TYPE_REGISTRY = Suppliers.memoize(() -> (ForgeRegistry)RegistryManager.ACTIVE.getRegistry(ComponentType.class));
    private final PropertyMap extendedState;
    private int id = -1;

    protected ComponentState(ComponentType owner, ImmutableMap<Property<?>, Comparable<?>> values, MapCodec<ComponentState> propertiesCodec, PropertyMap extendedState) {
        super((Object)owner, values, propertiesCodec);
        this.extendedState = extendedState;
    }

    void setID(int id) {
        this.id = id;
    }

    public ComponentState getRawState() {
        return this;
    }

    public ComponentType getComponentType() {
        return (ComponentType)((Object)this.f_61112_);
    }

    public int getID() {
        return this.id;
    }

    public AABB getBoundingBox() {
        return ((ComponentType)((Object)this.f_61112_)).getClientComponent().getBoundingBox(this);
    }

    public ItemStack getPickedItem() {
        return ((ComponentType)((Object)this.f_61112_)).getClientComponent().getPickedItem(this);
    }

    public void onPicking(Player player) {
        ((ComponentType)((Object)this.f_61112_)).getClientComponent().onPicking(this, player);
    }

    public InteractionResult use(Player player, InteractionHand hand, VecDirection sideHit, Vector3f hit) {
        return ((ComponentType)((Object)this.f_61112_)).getClientComponent().use(this, player, hand, sideHit, hit);
    }

    public boolean isTopSolid() {
        return ((ComponentType)((Object)this.f_61112_)).getClientComponent().isTopSolid(this);
    }

    public int getTint(int tintIndex) {
        return ((ComponentType)((Object)this.f_61112_)).getClientComponent().getTint(this, tintIndex);
    }

    public <T extends Comparable<T>> ComponentState setExtended(Property<T> property, T value) {
        return new Extended(this.getRawState(), this.extendedState.setProperty(property, value));
    }

    public <T extends Comparable<T>> T getExtended(Property<T> property) {
        return this.extendedState.getProperty(property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ComponentState that = (ComponentState)((Object)o);
        return this.getRawState() == that.getRawState() && this.extendedState.equals(that.extendedState);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getRawState(), this.extendedState});
    }

    public CompoundTag serialize(CompoundTag tag) {
        tag.m_128359_("component", ((ComponentType)((Object)this.f_61112_)).getRegistryName().toString());
        CompoundTag properties = new CompoundTag();
        this.m_61148_().forEach((p, v) -> properties.m_128359_(p.m_61708_(), p.m_6940_(v)));
        tag.m_128365_("properties", (Tag)properties);
        if (this instanceof Extended) {
            CompoundTag extendedProperties = new CompoundTag();
            this.extendedState.getValues().forEach((p, v) -> extendedProperties.m_128359_(p.m_61708_(), p.m_6940_(v)));
            tag.m_128365_("extended_properties", (Tag)extendedProperties);
        }
        return tag;
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(TYPE_REGISTRY.get().getID((IForgeRegistryEntry)((ComponentType)((Object)this.f_61112_))));
        buf.writeInt(this.getRawState().id);
        if (this instanceof Extended) {
            buf.writeBoolean(true);
            this.extendedState.serialize(buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    @Nullable
    public static ComponentState deserialize(CompoundTag tag) {
        ResourceLocation name = new ResourceLocation(tag.m_128461_("component"));
        ComponentType component = (ComponentType)TYPE_REGISTRY.get().getValue(name);
        if (component == null) {
            return null;
        }
        ComponentState state = component.getDefaultState();
        CompoundTag properties = tag.m_128469_("properties");
        for (Property property : state.m_61147_()) {
            String val;
            Optional value = property.m_6215_(val = properties.m_128461_(property.m_61708_()));
            if (!value.isPresent()) continue;
            state = (ComponentState)((Object)state.m_61124_(property, (Comparable)value.get()));
        }
        if (tag.m_128441_("extended_properties")) {
            CompoundTag extendedProperties = tag.m_128469_("extended_properties");
            for (Property<?> property : state.extendedState.getProperties()) {
                String val;
                Optional value = property.m_6215_(val = extendedProperties.m_128461_(property.m_61708_()));
                if (!value.isPresent()) continue;
                state = state.setExtended(property, (Comparable)value.get());
            }
        }
        return state;
    }

    @Nullable
    public static ComponentState deserialize(FriendlyByteBuf buf) {
        int typeId = buf.readInt();
        int stateId = buf.readInt();
        PropertyMap.PartialDeserialization partial = buf.readBoolean() ? PropertyMap.PartialDeserialization.deserialize(buf) : null;
        ComponentType component = (ComponentType)TYPE_REGISTRY.get().getValue(typeId);
        if (component == null) {
            return null;
        }
        ComponentState state = (ComponentState)((Object)component.getStateDefinition().m_61056_().get(stateId));
        if (partial != null) {
            PropertyMap extendedState = state.extendedState.deserialize(partial);
            return new Extended(state, extendedState);
        }
        return state;
    }

    private static class Extended
    extends ComponentState {
        private final ComponentState parent;

        protected Extended(ComponentState parent, PropertyMap extendedState) {
            super((ComponentType)((Object)parent.f_61112_), parent.m_61148_(), (MapCodec<ComponentState>)parent.f_61113_, extendedState);
            this.parent = parent;
        }

        @Override
        public ComponentState getRawState() {
            return this.parent;
        }
    }
}

